/**
 *
 */

#ifndef __instant_message_mgr_h__
#define __instant_message_mgr_h__

#include "csfunified/framework/UnifiedFactory.h"
#include "csfunified/services/interface/InstantMessageConversationService.h"
#include "csfunified/services/interface/InstantMessageCommandReceivedCallback.h"

#include "MeetingSDKWrap.h"

namespace CSFUnified {

class InstantMessageCallback : public InstantMessageCommandReceivedCallback
{
public:
	InstantMessageCallback();
	virtual ~InstantMessageCallback();

public:
	// InstantMessageCommandReceivedCallback
	void OnInstantMessageCommandReceived(std::string uri, std::string participantUri, InstantMessageCommandCodeEnum::InstantMessageCommandCode commandCode, std::string commandContent, std::string plaintext, std::string richtext, bool isGroupChatCmd);

};

class InstantMessageMgr
{
public:
	virtual ~InstantMessageMgr();

public:
	static InstantMessageMgr* getInstance();
	static void releaseInstance();

public:
    void start();
    void stop();
	void setUnifiedFactory(SMART_PTR_NS::shared_ptr<UnifiedFactory> unifiedFactory);

public:
	void sendMeetingInviteCmd(const std::string& buddyName, const std::string& cmdContent, const std::string& richText, const std::string& plainText);
	void sendMeetingCancelCmd(const std::string& buddyName, const std::string& cmdContent);
	void sendMeetingDeclineCmd(const std::string& buddyName, const std::string& cmdContent);
	void sendDesktopShareInviteCmd(const std::string& buddyName, const std::string& cmdContent, const std::string& richText, const std::string& plainText);
	void sendDesktopShareCancelCmd(const std::string& buddyName, const std::string& cmdContent);
	void sendDesktopShareDeclineCmd(const std::string& buddyName, const std::string& cmdContent);
	void sendMeetingRemindCmd(const std::string& buddyName, const std::string& cmdContent, const std::string& richText, const std::string& plainText);
	void sendCalendarRemindCmd(const std::string& buddyName, const std::string& cmdContent, const std::string& richText, const std::string& plainText);
	void sendCalendarInviteCmd(const std::string& buddyName, const std::string& cmdContent, const std::string& richText, const std::string& plainText);
    void SendCmd_CMRMeetingInvitation(const std::string& url, const std::string& cmdContent, const std::string& richText, const std::string& plainText);

    InstantMessageConversationService* getImProvider();

protected:
	InstantMessageMgr();
	
	void sendImCommand(const std::string& buddyName, InstantMessageCommandCodeEnum::InstantMessageCommandCode imcmd, const std::string& cmdContent, const std::string& richText, const std::string& plainText);
    void sendImCommandinMainThread(const std::string& buddyName, InstantMessageCommandCodeEnum::InstantMessageCommandCode imcmd, const std::string& cmdContent, const std::string& richText, const std::string& plainText);
    
    void sendGCCommand(const std::string& url, InstantMessageCommandCodeEnum::InstantMessageCommandCode imcmd, const std::string& cmdContent, const std::string& richText, const std::string& plainText);
    void sendGCCommandinMainThread(const std::string& url, InstantMessageCommandCodeEnum::InstantMessageCommandCode imcmd, const std::string& cmdContent, const std::string& richText, const std::string& plainText);
    

private:
	static InstantMessageMgr* m_pInstance;
	SMART_PTR_NS::shared_ptr<UnifiedFactory> m_unifiedFactory;
	SMART_PTR_NS::shared_ptr<InstantMessageConversationService> m_imProvider;
	SMART_PTR_NS::shared_ptr<InstantMessageCallback> m_callback;
};

}

#endif	// __instant_message_mgr_h__